<#
.SYNOPSIS
    Password Change Reminder - User Popup
.DESCRIPTION
    Reminds users to change their password and auto-deletes after password is changed
#>

Add-Type -AssemblyName System.Windows.Forms
Add-Type -AssemblyName System.Drawing

$Script:FlagPath = "C:\ABCD-Migration\PasswordFlags"
$Script:CurrentUser = $env:USERNAME

# Check if user already changed password
$flagFile = Join-Path $Script:FlagPath "$Script:CurrentUser.flag"
if (Test-Path $flagFile) {
    # User already changed password, delete this script
    $scriptPath = $MyInvocation.MyCommand.Path
    Start-Sleep -Seconds 2
    Remove-Item $scriptPath -Force -ErrorAction SilentlyContinue
    exit
}

# Create reminder form
$form = New-Object System.Windows.Forms.Form
$form.Text = "Important: Change Your Password"
$form.Size = New-Object System.Drawing.Size(500, 400)
$form.StartPosition = "CenterScreen"
$form.FormBorderStyle = "FixedDialog"
$form.MaximizeBox = $false
$form.MinimizeBox = $false
$form.TopMost = $true
$form.BackColor = [System.Drawing.Color]::WhiteSmoke

# Icon
$iconLabel = New-Object System.Windows.Forms.Label
$iconLabel.Text = "🔒"
$iconLabel.Location = New-Object System.Drawing.Point(210, 20)
$iconLabel.Size = New-Object System.Drawing.Size(80, 80)
$iconLabel.Font = New-Object System.Drawing.Font("Arial", 48)
$form.Controls.Add($iconLabel)

# Header
$lblHeader = New-Object System.Windows.Forms.Label
$lblHeader.Text = "Password Change Required"
$lblHeader.Location = New-Object System.Drawing.Point(50, 110)
$lblHeader.Size = New-Object System.Drawing.Size(400, 30)
$lblHeader.Font = New-Object System.Drawing.Font("Arial", 14, [System.Drawing.FontStyle]::Bold)
$lblHeader.TextAlign = [System.Drawing.ContentAlignment]::MiddleCenter
$lblHeader.ForeColor = [System.Drawing.Color]::DarkRed
$form.Controls.Add($lblHeader)

# Message
$lblMessage = New-Object System.Windows.Forms.Label
$lblMessage.Text = @"
Your account is currently using a temporary master password.

For security reasons, you must change your password as soon as possible.
"@
$lblMessage.Location = New-Object System.Drawing.Point(50, 150)
$lblMessage.Size = New-Object System.Drawing.Size(400, 60)
$lblMessage.Font = New-Object System.Drawing.Font("Arial", 10)
$lblMessage.TextAlign = [System.Drawing.ContentAlignment]::TopCenter
$form.Controls.Add($lblMessage)

# Instructions
$lblInstructions = New-Object System.Windows.Forms.Label
$lblInstructions.Text = @"
How to change your password:

1. Press Ctrl+Alt+Delete
2. Click "Change a password"
3. Enter your current (master) password
4. Enter your new password twice

Password Requirements:
• Minimum 8 characters
• Include uppercase and lowercase letters
• Include at least one number
• Include at least one special character
"@
$lblInstructions.Location = New-Object System.Drawing.Point(30, 220)
$lblInstructions.Size = New-Object System.Drawing.Size(440, 100)
$lblInstructions.Font = New-Object System.Drawing.Font("Consolas", 8)
$form.Controls.Add($lblInstructions)

# Buttons
$btnChangeNow = New-Object System.Windows.Forms.Button
$btnChangeNow.Text = "Change Password Now"
$btnChangeNow.Location = New-Object System.Drawing.Point(100, 330)
$btnChangeNow.Size = New-Object System.Drawing.Size(150, 30)
$btnChangeNow.BackColor = [System.Drawing.Color]::LightGreen
$btnChangeNow.Font = New-Object System.Drawing.Font("Arial", 9, [System.Drawing.FontStyle]::Bold)
$form.Controls.Add($btnChangeNow)

$btnRemindLater = New-Object System.Windows.Forms.Button
$btnRemindLater.Text = "Remind Me Later"
$btnRemindLater.Location = New-Object System.Drawing.Point(260, 330)
$btnRemindLater.Size = New-Object System.Drawing.Size(140, 30)
$btnRemindLater.BackColor = [System.Drawing.Color]::LightGray
$form.Controls.Add($btnRemindLater)

# Event handlers
$btnChangeNow.Add_Click({
    # Create flag file
    if (!(Test-Path $Script:FlagPath)) {
        New-Item -Path $Script:FlagPath -ItemType Directory -Force | Out-Null
    }
    
    $flagData = @{
        Username = $Script:CurrentUser
        ChangedDate = (Get-Date).ToString("yyyy-MM-dd HH:mm:ss")
        Computer = $env:COMPUTERNAME
    }
    
    $flagData | ConvertTo-Json | Out-File $flagFile -Encoding UTF8
    
    # Open password change dialog
    (New-Object -ComObject Shell.Application).WindowsSecurity()
    
    # Close form
    $form.Close()
    
    # Delete this script
    $scriptPath = $MyInvocation.MyCommand.Path
    Start-Sleep -Seconds 2
    Remove-Item $scriptPath -Force -ErrorAction SilentlyContinue
})

$btnRemindLater.Add_Click({
    $form.Close()
})

# Show form
$form.ShowDialog() | Out-Null
