@echo off
:: ============================================================
:: ABCD Admin Toolset v4.0 - Silent Installer
:: For wrapper/hidden execution
:: ============================================================

:: Check for admin silently
net session >nul 2>&1
if %errorlevel% neq 0 (
    :: Try to self-elevate
    powershell -Command "Start-Process '%~f0' -Verb RunAs" 2>nul
    exit /b
)

set "SOURCE=%~dp0"
set "DEST=C:\ABCD-Admin-Toolset"

:: Remove old installation
if exist "%DEST%" rmdir /s /q "%DEST%" 2>nul
if exist "C:\ABCD-Migration" rmdir /s /q "C:\ABCD-Migration" 2>nul
timeout /t 1 /nobreak >nul

:: Create directories
mkdir "%DEST%" 2>nul
mkdir "%DEST%\Modules" 2>nul
mkdir "%DEST%\Tools" 2>nul
mkdir "%DEST%\Assets" 2>nul
mkdir "%DEST%\Logs" 2>nul
mkdir "%DEST%\Backup" 2>nul
mkdir "%DEST%\Scripts" 2>nul
mkdir "%DEST%\Settings" 2>nul
mkdir "%DEST%\LaZagne" 2>nul
mkdir "%DEST%\Launcher" 2>nul
mkdir "%DEST%\Wrapper" 2>nul

:: Copy files
copy /Y "%SOURCE%*.ps1" "%DEST%\" >nul 2>&1
copy /Y "%SOURCE%*.vbs" "%DEST%\" >nul 2>&1
copy /Y "%SOURCE%*.bat" "%DEST%\" >nul 2>&1
copy /Y "%SOURCE%*.txt" "%DEST%\" >nul 2>&1
copy /Y "%SOURCE%*.md" "%DEST%\" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Modules" "%DEST%\Modules" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Tools" "%DEST%\Tools" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Assets" "%DEST%\Assets" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Scripts" "%DEST%\Scripts" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%LaZagne" "%DEST%\LaZagne" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Launcher" "%DEST%\Launcher" >nul 2>&1
xcopy /Y /Q /E /I "%SOURCE%Wrapper" "%DEST%\Wrapper" >nul 2>&1

:: Create VBS launcher
(
echo Set objShell = CreateObject^("WScript.Shell"^)
echo Set objFSO = CreateObject^("Scripting.FileSystemObject"^)
echo strPath = objFSO.GetParentFolderName^(WScript.ScriptFullName^)
echo strScript = strPath ^& "\ABCD-Migration-GUI.ps1"
echo If Not objFSO.FileExists^(strScript^) Then
echo     MsgBox "ABCD-Migration-GUI.ps1 not found!", vbCritical, "Error"
echo     WScript.Quit 1
echo End If
echo objShell.Run "powershell -NoProfile -ExecutionPolicy Bypass -WindowStyle Hidden -File """ ^& strScript ^& """", 0, False
) > "%DEST%\ABCD-Admin-Toolset.vbs"

:: Try to compile EXE
set "LAUNCHPATH=%DEST%\ABCD-Admin-Toolset.vbs"
for /f "delims=" %%i in ('dir /b /o-n "%WINDIR%\Microsoft.NET\Framework64\v4*" 2^>nul') do (
    if exist "%WINDIR%\Microsoft.NET\Framework64\%%i\csc.exe" (
        "%WINDIR%\Microsoft.NET\Framework64\%%i\csc.exe" /nologo /target:winexe /out:"%DEST%\ABCDAdminToolset.exe" "%DEST%\Launcher\ABCDMigration.cs" >nul 2>&1
        if exist "%DEST%\ABCDAdminToolset.exe" set "LAUNCHPATH=%DEST%\ABCDAdminToolset.exe"
        goto :donecsc
    )
)
:donecsc

:: Create desktop shortcut with admin flag
set "PS=%TEMP%\mksc.ps1"
echo $ws=New-Object -Com WScript.Shell > "%PS%"
echo $sc=$ws.CreateShortcut("$env:USERPROFILE\Desktop\ABCD Admin Toolset.lnk") >> "%PS%"
echo $sc.TargetPath='%LAUNCHPATH%' >> "%PS%"
echo $sc.WorkingDirectory='%DEST%' >> "%PS%"
echo $sc.Description='ABCD Admin Toolset v4.0' >> "%PS%"
echo $sc.IconLocation='%DEST%\Assets\ABCD-Icon.ico' >> "%PS%"
echo $sc.Save() >> "%PS%"
echo $b=[IO.File]::ReadAllBytes("$env:USERPROFILE\Desktop\ABCD Admin Toolset.lnk") >> "%PS%"
echo $b[0x15]=$b[0x15]-bor 0x20 >> "%PS%"
echo [IO.File]::WriteAllBytes("$env:USERPROFILE\Desktop\ABCD Admin Toolset.lnk",$b) >> "%PS%"
powershell -NoProfile -ExecutionPolicy Bypass -File "%PS%" >nul 2>&1
del "%PS%" 2>nul

:: Register in Add/Remove Programs (Control Panel)
set "REGKEY=HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ABCDAdminToolset"
reg add "%REGKEY%" /v "DisplayName" /t REG_SZ /d "ABCD Admin Toolset v4.0" /f >nul 2>&1
reg add "%REGKEY%" /v "DisplayVersion" /t REG_SZ /d "4.0" /f >nul 2>&1
reg add "%REGKEY%" /v "Publisher" /t REG_SZ /d "ABC&D Systems" /f >nul 2>&1
reg add "%REGKEY%" /v "InstallLocation" /t REG_SZ /d "%DEST%" /f >nul 2>&1
reg add "%REGKEY%" /v "UninstallString" /t REG_SZ /d "\"%DEST%\Uninstall.bat\"" /f >nul 2>&1
reg add "%REGKEY%" /v "DisplayIcon" /t REG_SZ /d "%DEST%\Assets\ABCD-Icon.ico" /f >nul 2>&1
reg add "%REGKEY%" /v "NoModify" /t REG_DWORD /d 1 /f >nul 2>&1
reg add "%REGKEY%" /v "NoRepair" /t REG_DWORD /d 1 /f >nul 2>&1
reg add "%REGKEY%" /v "EstimatedSize" /t REG_DWORD /d 650000 /f >nul 2>&1

:: Also register in ABCD Systems key
reg add "HKLM\SOFTWARE\ABCD Systems\Admin Toolset" /v "Version" /t REG_SZ /d "4.0" /f >nul 2>&1
reg add "HKLM\SOFTWARE\ABCD Systems\Admin Toolset" /v "InstallPath" /t REG_SZ /d "%DEST%" /f >nul 2>&1

:: Launch immediately
if exist "%DEST%\ABCDAdminToolset.exe" (
    start "" "%DEST%\ABCDAdminToolset.exe"
) else (
    start "" wscript.exe "%DEST%\ABCD-Admin-Toolset.vbs"
)

exit /b 0
