using System;
using System.Diagnostics;
using System.IO;
using System.Windows.Forms;

namespace ABCDMigration
{
    static class Program
    {
        [STAThread]
        static void Main()
        {
            try
            {
                // Get the directory where this EXE is located
                string exePath = AppDomain.CurrentDomain.BaseDirectory;
                string scriptPath = Path.Combine(exePath, "ABCD-Migration-GUI.ps1");
                
                // Check if script exists
                if (!File.Exists(scriptPath))
                {
                    MessageBox.Show(
                        "Error: ABCD-Migration-GUI.ps1 not found!\n\nExpected location:\n" + scriptPath,
                        "ABCD Systems Migration Tool",
                        MessageBoxButtons.OK,
                        MessageBoxIcon.Error
                    );
                    return;
                }
                
                // Launch PowerShell hidden with the GUI script
                ProcessStartInfo psi = new ProcessStartInfo
                {
                    FileName = "powershell.exe",
                    Arguments = string.Format(
                        "-ExecutionPolicy Bypass -WindowStyle Hidden -File \"{0}\"",
                        scriptPath
                    ),
                    WorkingDirectory = exePath,
                    UseShellExecute = false,
                    CreateNoWindow = true
                };
                
                Process.Start(psi);
            }
            catch (Exception ex)
            {
                MessageBox.Show(
                    "Error launching ABCD Migration Tool:\n\n" + ex.Message,
                    "ABCD Systems Migration Tool",
                    MessageBoxButtons.OK,
                    MessageBoxIcon.Error
                );
            }
        }
    }
}
