@echo off
:: ============================================================
:: Compile ABCD Migration Tool Launcher
:: This creates ABCDMigration.exe with embedded admin manifest
:: ============================================================

echo Compiling ABCD Migration Tool Launcher...

:: Find the latest .NET Framework csc.exe
set CSC=
for /f "delims=" %%i in ('dir /b /o-n "%WINDIR%\Microsoft.NET\Framework64\v4*" 2^>nul') do (
    if exist "%WINDIR%\Microsoft.NET\Framework64\%%i\csc.exe" (
        set "CSC=%WINDIR%\Microsoft.NET\Framework64\%%i\csc.exe"
        goto :found
    )
)
for /f "delims=" %%i in ('dir /b /o-n "%WINDIR%\Microsoft.NET\Framework\v4*" 2^>nul') do (
    if exist "%WINDIR%\Microsoft.NET\Framework\%%i\csc.exe" (
        set "CSC=%WINDIR%\Microsoft.NET\Framework\%%i\csc.exe"
        goto :found
    )
)

echo ERROR: Could not find csc.exe (.NET Framework compiler)
echo Please install .NET Framework 4.x
pause
exit /b 1

:found
echo Using compiler: %CSC%

:: Compile with embedded manifest
"%CSC%" /nologo /target:winexe /win32manifest:ABCDMigration.manifest /out:ABCDMigration.exe ABCDMigration.cs

if %errorlevel% equ 0 (
    echo.
    echo SUCCESS: ABCDMigration.exe created!
    echo.
    echo Copy ABCDMigration.exe to C:\ABCD-Migration\ and use it as the launcher.
) else (
    echo.
    echo ERROR: Compilation failed!
)

pause
