@echo off
:: =============================================================================
:: ABCD Migration Tool - Backup Cleanup Script
:: Removes files older than specified retention period
:: =============================================================================

setlocal EnableDelayedExpansion

:: Default values
set "BACKUP_PATH=E:\Backup"
set "RETENTION_DAYS=7"

:: Parse command line arguments
:parse_args
if "%~1"=="" goto :run_cleanup
if /i "%~1"=="-path" set "BACKUP_PATH=%~2" & shift & shift & goto :parse_args
if /i "%~1"=="-days" set "RETENTION_DAYS=%~2" & shift & shift & goto :parse_args
if /i "%~1"=="-?" goto :show_help
if /i "%~1"=="/?" goto :show_help
shift
goto :parse_args

:show_help
echo.
echo ABCD Migration Tool - Backup Cleanup
echo =====================================
echo.
echo Usage: Cleanup-Backups.bat [-path "E:\Backup"] [-days 7]
echo.
echo Options:
echo   -path    Path to clean (default: E:\Backup)
echo   -days    Delete files older than N days (default: 7)
echo.
echo Examples:
echo   Cleanup-Backups.bat
echo   Cleanup-Backups.bat -path "D:\VMBackups" -days 14
echo.
goto :eof

:run_cleanup
echo.
echo =====================================================
echo ABCD Migration Tool - Backup Cleanup
echo =====================================================
echo Path: %BACKUP_PATH%
echo Retention: %RETENTION_DAYS% days
echo =====================================================
echo.

if not exist "%BACKUP_PATH%" (
    echo ERROR: Path not found: %BACKUP_PATH%
    exit /b 1
)

echo Removing files older than %RETENTION_DAYS% days...
echo.

:: Remove old files
cd /d "%BACKUP_PATH%"
forfiles /p "%BACKUP_PATH%" /s /m *.* /d -%RETENTION_DAYS% /c "cmd /c if @isdir==FALSE del /q @path" 2>nul

echo.
echo Removing empty folders...

:: Remove empty folders (multiple passes for nested)
for /L %%i in (1,1,5) do (
    for /f "delims=" %%d in ('dir /ad /b /s "%BACKUP_PATH%" 2^>nul ^| sort /r') do (
        rd "%%d" 2>nul
    )
)

echo.
echo =====================================================
echo Cleanup complete!
echo =====================================================
echo.

exit /b 0
