' ABC&D Systems Backup and Migration Tools v4.0 - Silent Setup
' Does all installation natively in VBS - NO command windows shown

Option Explicit
On Error Resume Next

Dim objShell, objFSO, objShellApp
Dim strSourcePath, strInstallPath, strDesktop

Set objShell = CreateObject("WScript.Shell")
Set objFSO = CreateObject("Scripting.FileSystemObject")
Set objShellApp = CreateObject("Shell.Application")

strSourcePath = objFSO.GetParentFolderName(WScript.ScriptFullName)
strInstallPath = "C:\ABCD-Migration"
strDesktop = objShell.SpecialFolders("Desktop")

' Check if running as admin
If Not IsAdmin() Then
    ' Relaunch as admin, completely hidden (0 = hidden)
    objShellApp.ShellExecute "wscript.exe", """" & WScript.ScriptFullName & """", "", "runas", 0
    WScript.Quit
End If

' === INSTALLATION (Running as Admin) ===

' Create directories
CreateFolderIfNotExist strInstallPath
CreateFolderIfNotExist strInstallPath & "\Modules"
CreateFolderIfNotExist strInstallPath & "\Tools"
CreateFolderIfNotExist strInstallPath & "\Assets"
CreateFolderIfNotExist strInstallPath & "\Logs"
CreateFolderIfNotExist strInstallPath & "\Backup"
CreateFolderIfNotExist strInstallPath & "\Scripts"
CreateFolderIfNotExist strInstallPath & "\Settings"
CreateFolderIfNotExist strInstallPath & "\LaZagne"
CreateFolderIfNotExist strInstallPath & "\Launcher"

' Copy files
CopyFileIfExists strSourcePath & "\ABCD-Migration-GUI.ps1", strInstallPath & "\"
CopyFileIfExists strSourcePath & "\ABCD-Migration-Scheduled.ps1", strInstallPath & "\"
CopyFileIfExists strSourcePath & "\ABCD-Migration-Tool.vbs", strInstallPath & "\"
CopyFileIfExists strSourcePath & "\Uninstall.bat", strInstallPath & "\"
CopyFileIfExists strSourcePath & "\INSTALL.bat", strInstallPath & "\"

' Copy folders
CopyFolderContents strSourcePath & "\Modules", strInstallPath & "\Modules"
CopyFolderContents strSourcePath & "\Tools", strInstallPath & "\Tools"
CopyFolderContents strSourcePath & "\Assets", strInstallPath & "\Assets"
CopyFolderContents strSourcePath & "\Scripts", strInstallPath & "\Scripts"
CopyFolderContents strSourcePath & "\LaZagne", strInstallPath & "\LaZagne"
CopyFolderContents strSourcePath & "\Launcher", strInstallPath & "\Launcher"

' Try to compile EXE launcher (silently via PowerShell)
Dim strPSCompile
strPSCompile = "powershell.exe -NoProfile -WindowStyle Hidden -ExecutionPolicy Bypass -Command """ & _
    "$csc = Get-ChildItem 'C:\Windows\Microsoft.NET\Framework64\v4*\csc.exe' -ErrorAction SilentlyContinue | Select-Object -First 1; " & _
    "if (-not $csc) { $csc = Get-ChildItem 'C:\Windows\Microsoft.NET\Framework\v4*\csc.exe' -ErrorAction SilentlyContinue | Select-Object -First 1 }; " & _
    "if ($csc -and (Test-Path 'C:\ABCD-Migration\Launcher\ABCDMigration.cs')) { " & _
    "Push-Location 'C:\ABCD-Migration\Launcher'; " & _
    "& $csc.FullName /nologo /target:winexe /win32manifest:ABCDMigration.manifest /out:..\ABCDMigration.exe ABCDMigration.cs 2>$null; " & _
    "Pop-Location }" & _
    """"
objShell.Run strPSCompile, 0, True

' Determine launcher type
Dim strLauncher, strTarget
If objFSO.FileExists(strInstallPath & "\ABCDMigration.exe") Then
    strLauncher = "EXE"
    strTarget = strInstallPath & "\ABCDMigration.exe"
Else
    strLauncher = "VBS"
    strTarget = strInstallPath & "\ABCD-Migration-Tool.vbs"
End If

' Create desktop shortcut
Dim objShortcut
Set objShortcut = objShell.CreateShortcut(strDesktop & "\ABCD Migration Tool.lnk")
objShortcut.TargetPath = strTarget
objShortcut.WorkingDirectory = strInstallPath
objShortcut.Description = "ABC&D Systems Backup and Migration Tools v4.0"
objShortcut.IconLocation = strInstallPath & "\Assets\ABCD-Icon.ico,0"
objShortcut.Save

' Set shortcut to Run as Administrator (modify byte 0x15)
Dim strPSAdmin
strPSAdmin = "powershell.exe -NoProfile -WindowStyle Hidden -ExecutionPolicy Bypass -Command """ & _
    "$s = [Environment]::GetFolderPath('Desktop') + '\ABCD Migration Tool.lnk'; " & _
    "if (Test-Path $s) { $b = [IO.File]::ReadAllBytes($s); $b[0x15] = $b[0x15] -bor 0x20; [IO.File]::WriteAllBytes($s, $b) }" & _
    """"
objShell.Run strPSAdmin, 0, True

' Register in Add/Remove Programs
Dim strRegKey
strRegKey = "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ABCDMigrationTool\"
objShell.RegWrite strRegKey & "DisplayName", "ABC&D Systems Backup and Migration Tools", "REG_SZ"
objShell.RegWrite strRegKey & "DisplayVersion", "2.2", "REG_SZ"
objShell.RegWrite strRegKey & "Publisher", "ABCD Systems", "REG_SZ"
objShell.RegWrite strRegKey & "InstallLocation", strInstallPath, "REG_SZ"
objShell.RegWrite strRegKey & "InstallDate", Year(Date) & Right("0" & Month(Date), 2) & Right("0" & Day(Date), 2), "REG_SZ"
objShell.RegWrite strRegKey & "UninstallString", strInstallPath & "\Uninstall.bat", "REG_SZ"
objShell.RegWrite strRegKey & "DisplayIcon", strInstallPath & "\Assets\ABCD-Icon.ico,0", "REG_SZ"
objShell.RegWrite strRegKey & "EstimatedSize", 5120, "REG_DWORD"
objShell.RegWrite strRegKey & "NoRepair", 1, "REG_DWORD"
objShell.RegWrite strRegKey & "NoModify", 1, "REG_DWORD"

' Store version info
objShell.RegWrite "HKLM\SOFTWARE\ABCD Systems\Migration Tool\Version", "2.2", "REG_SZ"
objShell.RegWrite "HKLM\SOFTWARE\ABCD Systems\Migration Tool\Launcher", strLauncher, "REG_SZ"

' Launch application
If strLauncher = "EXE" Then
    objShell.Run """" & strInstallPath & "\ABCDMigration.exe""", 1, False
Else
    objShell.Run "wscript.exe """ & strInstallPath & "\ABCD-Migration-Tool.vbs""", 0, False
End If

WScript.Quit 0

' === HELPER FUNCTIONS ===

Function IsAdmin()
    On Error Resume Next
    Dim testFile, f
    testFile = objFSO.GetSpecialFolder(0) & "\abcd_admin_test_" & Int(Rnd * 10000) & ".tmp"
    Set f = objFSO.CreateTextFile(testFile, True)
    If Err.Number = 0 Then
        f.Close
        objFSO.DeleteFile testFile
        IsAdmin = True
    Else
        IsAdmin = False
    End If
    Err.Clear
    On Error GoTo 0
End Function

Sub CreateFolderIfNotExist(strPath)
    If Not objFSO.FolderExists(strPath) Then
        objFSO.CreateFolder(strPath)
    End If
End Sub

Sub CopyFileIfExists(strSource, strDest)
    If objFSO.FileExists(strSource) Then
        objFSO.CopyFile strSource, strDest, True
    End If
End Sub

Sub CopyFolderContents(strSourceFolder, strDestFolder)
    Dim objFolder, objFile, objSubFolder
    
    If Not objFSO.FolderExists(strSourceFolder) Then Exit Sub
    If Not objFSO.FolderExists(strDestFolder) Then objFSO.CreateFolder(strDestFolder)
    
    Set objFolder = objFSO.GetFolder(strSourceFolder)
    
    ' Copy files
    For Each objFile In objFolder.Files
        objFSO.CopyFile objFile.Path, strDestFolder & "\", True
    Next
    
    ' Copy subfolders recursively
    For Each objSubFolder In objFolder.SubFolders
        CopyFolderContents objSubFolder.Path, strDestFolder & "\" & objSubFolder.Name
    Next
End Sub
