@echo off
REM ============================================================
REM QuickBooks License Cleanup Tool
REM Removes licensing files to allow fresh activation
REM Run as Administrator!
REM ============================================================

echo.
echo ============================================================
echo    QuickBooks License Cleanup Tool
echo ============================================================
echo.
echo This will remove QuickBooks licensing data so you can
echo re-enter your license key and activate fresh.
echo.
echo Make sure you have your license key ready!
echo.
pause

REM Check for admin
net session >nul 2>&1
if %errorLevel% neq 0 (
    echo.
    echo ERROR: Please run as Administrator!
    echo Right-click and select "Run as administrator"
    pause
    exit /b 1
)

echo.
echo Stopping QuickBooks processes...
taskkill /f /im QBW32.exe 2>nul
taskkill /f /im QBW.exe 2>nul
taskkill /f /im qbupdate.exe 2>nul
taskkill /f /im QBCFMonitorService.exe 2>nul
taskkill /f /im QBDBMgrN.exe 2>nul
taskkill /f /im QBDBMgr.exe 2>nul
timeout /t 2 >nul

echo.
echo Removing Entitlement Files...

REM Entitlement Client folders (main licensing)
if exist "C:\ProgramData\Intuit\Entitlement Client" (
    echo   Cleaning: C:\ProgramData\Intuit\Entitlement Client
    rd /s /q "C:\ProgramData\Intuit\Entitlement Client" 2>nul
)

if exist "C:\ProgramData\Intuit\Entitlement Client\v8" (
    rd /s /q "C:\ProgramData\Intuit\Entitlement Client\v8" 2>nul
)

if exist "C:\ProgramData\Intuit\Entitlement Client\v6" (
    rd /s /q "C:\ProgramData\Intuit\Entitlement Client\v6" 2>nul
)

REM Common Files Intuit
if exist "C:\ProgramData\COMMON FILES\INTUIT" (
    echo   Cleaning: C:\ProgramData\COMMON FILES\INTUIT
    rd /s /q "C:\ProgramData\COMMON FILES\INTUIT" 2>nul
)

REM Delete ecml files anywhere in Intuit folder
echo   Cleaning: *.ecml files
del /s /q "C:\ProgramData\Intuit\*.ecml" 2>nul

REM Registration data
if exist "C:\ProgramData\Intuit\QuickBooks Enterprise Solutions 24.0\qbregistration.dat" (
    del /q "C:\ProgramData\Intuit\QuickBooks Enterprise Solutions 24.0\qbregistration.dat" 2>nul
)
if exist "C:\ProgramData\Intuit\QuickBooks Enterprise Solutions 23.0\qbregistration.dat" (
    del /q "C:\ProgramData\Intuit\QuickBooks Enterprise Solutions 23.0\qbregistration.dat" 2>nul
)
if exist "C:\ProgramData\Intuit\QuickBooks\qbregistration.dat" (
    del /q "C:\ProgramData\Intuit\QuickBooks\qbregistration.dat" 2>nul
)

echo.
echo Cleaning Registry Licensing Keys...

REM Remove specific licensing registry keys (keep app settings)
reg delete "HKLM\SOFTWARE\Intuit\QuickBooks\CurrentVersion\Registration" /f 2>nul
reg delete "HKLM\SOFTWARE\WOW6432Node\Intuit\QuickBooks\CurrentVersion\Registration" /f 2>nul
reg delete "HKLM\SOFTWARE\Intuit\QuickBooks Enterprise Solutions\CurrentVersion\Registration" /f 2>nul
reg delete "HKLM\SOFTWARE\WOW6432Node\Intuit\QuickBooks Enterprise Solutions\CurrentVersion\Registration" /f 2>nul

REM Entitlement registry
reg delete "HKLM\SOFTWARE\Intuit\Entitlement Client" /f 2>nul
reg delete "HKLM\SOFTWARE\WOW6432Node\Intuit\Entitlement Client" /f 2>nul
reg delete "HKCU\SOFTWARE\Intuit\Entitlement Client" /f 2>nul

echo.
echo ============================================================
echo    CLEANUP COMPLETE!
echo ============================================================
echo.
echo Next steps:
echo   1. Open QuickBooks
echo   2. When prompted, enter your License Key
echo   3. Complete activation
echo.
echo If you still have issues, you may need to:
echo   - Run the QuickBooks Install Diagnostic Tool
echo   - Contact Intuit support: 1-800-446-8848
echo.
pause
