@echo off
:: =============================================================
:: ABCD-Migration Quick Recovery Tools
:: Run as Administrator to find license keys and passwords
:: =============================================================

title ABCD-Migration Recovery Tools
color 0B

echo.
echo  ========================================
echo   ABCD-Migration Recovery Tools
echo  ========================================
echo.

:: Check for admin
net session >nul 2>&1
if %errorlevel% neq 0 (
    echo  ERROR: Please run as Administrator!
    echo.
    echo  Right-click this file and select
    echo  "Run as administrator"
    echo.
    pause
    exit /b 1
)

echo  This tool will:
echo    1. Find software license keys
echo    2. Find WiFi passwords
echo    3. [Optional] Find saved passwords
echo.
echo  Reports will be saved to your Desktop.
echo.
echo  ========================================
echo.

:MENU
echo  Select an option:
echo.
echo    [1] Find License Keys (Windows, Office, QuickBooks, etc.)
echo    [2] Find License Keys + WiFi Passwords
echo    [3] Find ALL (License Keys + WiFi + Saved Passwords)
echo    [4] Exit
echo.
set /p choice="  Enter choice (1-4): "

if "%choice%"=="1" goto KEYS_ONLY
if "%choice%"=="2" goto KEYS_WIFI
if "%choice%"=="3" goto ALL
if "%choice%"=="4" exit /b 0

echo  Invalid choice. Try again.
echo.
goto MENU

:KEYS_ONLY
echo.
echo  Finding license keys...
powershell -ExecutionPolicy Bypass -File "%~dp0Modules\KeyFinder.ps1" -Command "Export-AllLicenseKeys"
if %errorlevel% neq 0 (
    echo  Running inline KeyFinder...
    powershell -ExecutionPolicy Bypass -Command "& { . '%~dp0Modules\KeyFinder.ps1'; Export-AllLicenseKeys -OutputPath 'C:\ABCD-Migration\Backup' }"
)
echo.
echo  Done! Check your Desktop for License_Keys_Report.html
pause
goto MENU

:KEYS_WIFI
echo.
echo  Finding license keys and WiFi passwords...
powershell -ExecutionPolicy Bypass -Command "& { . '%~dp0Modules\KeyFinder.ps1'; Export-AllLicenseKeys -OutputPath 'C:\ABCD-Migration\Backup' -IncludeWifi }"
echo.
echo  Done! Check your Desktop for License_Keys_Report.html
pause
goto MENU

:ALL
echo.
echo  Finding ALL recoverable keys and passwords...
echo.
echo  Step 1: License Keys + WiFi...
powershell -ExecutionPolicy Bypass -Command "& { . '%~dp0Modules\KeyFinder.ps1'; Export-AllLicenseKeys -OutputPath 'C:\ABCD-Migration\Backup' -IncludeWifi }"
echo.
echo  Step 2: Saved Passwords (LaZagne)...

if exist "%~dp0Tools\LaZagne.exe" (
    "%~dp0Tools\LaZagne.exe" all -oA -output "C:\ABCD-Migration\Backup"
    echo.
    echo  Passwords saved to C:\ABCD-Migration\Backup
) else (
    echo.
    echo  LaZagne.exe not found in Tools folder.
    echo  Download from: https://github.com/AlessandroZ/LaZagne/releases
    echo  Place in: %~dp0Tools\LaZagne.exe
)

echo.
echo  Done! Check:
echo    - Desktop: License_Keys_Report.html
echo    - C:\ABCD-Migration\Backup\ for password files
echo.
pause
goto MENU
