@echo off
:: ============================================================
:: ABCD Admin Toolset v4.0 - Silent Uninstaller
:: ============================================================

:: Check for admin silently
net session >nul 2>&1
if %errorlevel% neq 0 (
    powershell -Command "Start-Process '%~f0' -Verb RunAs" 2>nul
    exit /b
)

set "DEST=C:\ABCD-Admin-Toolset"

:: Kill any running instances
taskkill /f /im powershell.exe /fi "WINDOWTITLE eq *ABCD*" >nul 2>&1
taskkill /f /im ABCDAdminToolset.exe >nul 2>&1
timeout /t 1 /nobreak >nul

:: Remove scheduled tasks
schtasks /delete /tn "ABCD Migration Daily" /f >nul 2>&1
schtasks /delete /tn "ABCD Backup Daily" /f >nul 2>&1

:: Remove desktop shortcut
del "%USERPROFILE%\Desktop\ABCD Admin Toolset.lnk" 2>nul
del "%PUBLIC%\Desktop\ABCD Admin Toolset.lnk" 2>nul

:: Remove from Add/Remove Programs (Control Panel)
reg delete "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\ABCDAdminToolset" /f >nul 2>&1

:: Remove ABCD Systems registry key
reg delete "HKLM\SOFTWARE\ABCD Systems\Admin Toolset" /f >nul 2>&1

:: Remove installation directory
if exist "%DEST%" rmdir /s /q "%DEST%" 2>nul

:: Also remove old location if exists
if exist "C:\ABCD-Migration" rmdir /s /q "C:\ABCD-Migration" 2>nul

exit /b 0
